/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions;

import cc.arduino.contributions.VersionComparator;
import cc.arduino.contributions.packages.ContributedPlatform;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import processing.app.Base;
import processing.app.BaseNoGui;
import processing.app.I18n;
import processing.app.PreferencesData;

public class BuiltInCoreIsNewerCheck
implements Runnable {
    private final Base base;

    public BuiltInCoreIsNewerCheck(Base base) {
        this.base = base;
    }

    @Override
    public void run() {
        try {
            this.builtInPackageIsNewerCheck();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void builtInPackageIsNewerCheck() throws InterruptedException {
        if (PreferencesData.getInteger((String)"builtin_platform_is_newer", (int)-1) >= 10817) {
            return;
        }
        List contributedPlatforms = BaseNoGui.indexer.getPackages().stream().map(pack -> pack.getPlatforms()).flatMap(platfs -> platfs.stream()).collect(Collectors.toList());
        Optional<ContributedPlatform> mayInstalledBuiltIn = contributedPlatforms.stream().filter(p -> p.isInstalled()).filter(p -> p.isBuiltIn()).findFirst();
        if (!mayInstalledBuiltIn.isPresent()) {
            return;
        }
        ContributedPlatform installedBuiltIn = mayInstalledBuiltIn.get();
        ContributedPlatform installedNotBuiltIn = BaseNoGui.indexer.getInstalled(installedBuiltIn.getParentPackage().getName(), installedBuiltIn.getArchitecture());
        if (installedNotBuiltIn == null) {
            return;
        }
        while (!this.base.hasActiveEditor()) {
            Thread.sleep(100L);
        }
        if (VersionComparator.greaterThan((String)installedBuiltIn.getParsedVersion(), (String)installedNotBuiltIn.getParsedVersion())) {
            SwingUtilities.invokeLater(() -> {
                PreferencesData.setInteger((String)"builtin_platform_is_newer", (int)10817);
                assert (this.base.hasActiveEditor());
                int chosenOption = JOptionPane.showConfirmDialog(this.base.getActiveEditor(), I18n.format((String)I18n.tr((String)"The IDE includes an updated {0} package, but you're using an older one.\nDo you want to upgrade {0}?"), (Object[])new Object[]{installedBuiltIn.getName()}), I18n.format((String)I18n.tr((String)"A newer {0} package is available"), (Object[])new Object[]{installedBuiltIn.getName()}), 0, 3);
                if (chosenOption == 0) {
                    try {
                        this.base.openBoardsManager(installedBuiltIn.getName(), "");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }
}

